﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Class_Library;

public partial class _Default : System.Web.UI.Page
{
    //this function handles the load event for the page
    protected void Page_Load(object sender, EventArgs e)
    {
        //if this is the first time the page is displayed
        if (IsPostBack == false)
        { 
            //update the list box
            DisplayAddresses();
        }
    }

    void DisplayAddresses()
    {
        //create an instance of the County Collection
        Class_Library.clsAddressCollection Addresses = new Class_Library.clsAddressCollection();
        //set the data source to the list of counties in the collection
        lstAddresses.DataSource = Addresses.AddressList;
        //set the name of the primary key
        lstAddresses.DataValueField = "AddressID";
        //set the data field to display
        lstAddresses.DataTextField = "PostCode";
        //bind the data to the list
        lstAddresses.DataBind();
    }

    //event handler for the add button
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        //store -1 into the session object to indicate this is a new record
        Session["AddressID"] = -1;
        //redirect to the data entry page
        Response.Redirect("AnAddress.aspx");
    }

    //event handler for the edit button
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        //var to store the primary key value of the record to be edited
        Int32 AddressID;
        //if a record has been selected from the list
        if (lstAddresses.SelectedIndex != -1)
        {
            //get the primary key value of the record to edit
            AddressID = Convert.ToInt32(lstAddresses.SelectedValue);
            //store the data in the session object
            Session["AddressID"] = AddressID;
            //redirect to the edit page
            Response.Redirect("AnAddress.aspx");
        }
        else//if no record has been selected
        {
            //display an error
            lblError.Text = "Please select a record to delete from the list";
        }
    }

    //event handler for the delete button
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        //var to store the primary key value of the record to be deleted
        Int32 AddressID;
        //if a record has been selected from the list
        if (lstAddresses.SelectedIndex != -1)
        {
            //get the primary key value of the record to delete
            AddressID = Convert.ToInt32(lstAddresses.SelectedValue);
            //store the data in the session object
            Session["AddressID"] = AddressID;
            //redirect to the delete page
            Response.Redirect("Delete.aspx");
        }
        else //if no record has been selected
        {
            //display an error
            lblError.Text = "Please select a record to delete from the list";
        }
    }

    //event handler for the apply button
    protected void btnApply_Click(object sender, EventArgs e)
    {
        //create an instance of the address collection
        clsAddressCollection Addresses = new clsAddressCollection();
        Addresses.ReportByPostCode(txtPostCode.Text);
        lstAddresses.DataSource = Addresses.AddressList;
        //set the name of the primary key 
        lstAddresses.DataValueField = "AddressID";
        //set the name of the field to display
        lstAddresses.DataTextField = "PostCode";
        //bind the data to the list
        lstAddresses.DataBind();
    }

    //event hanlder for the display all button
    protected void btnDisplayAll_Click(object sender, EventArgs e)
    {
        //create an instance of the address collection
        clsAddressCollection Addresses = new clsAddressCollection();
        Addresses.ReportByPostCode("");
        //clear any exisiting filter to tidy up the interface
        txtPostCode.Text = "";
        lstAddresses.DataSource = Addresses.AddressList;
        //set the name of the primary key
        lstAddresses.DataValueField = "AddressID";
        //set the name of the field to display
        lstAddresses.DataTextField = "PostCode";
        //bind the data to the list
        lstAddresses.DataBind();
    }
}